--Create the Residential HVAC weight multiplied version of the measure impacts table (to be summed later)
SET search_path TO "MC_results_database";
DROP TABLE IF EXISTS meas_impacts_hvactmp;
CREATE TABLE meas_impacts_hvactmp AS 
SELECT
"EnergyImpactID",
meas_impacts_2020_reshvac."PA",
meas_impacts_2020_reshvac."BldgType",
meas_impacts_2020_reshvac."BldgVint",
meas_impacts_2020_reshvac."BldgLoc",
meas_impacts_2020_reshvac."BldgHVAC",
wtval as "wt_hvac",
--calculate the weight-multiplied version of the corresponding parameter
"NormUnit",
"NumUnit" * wtval as "NumUnit",
"MeasArea" * wtval   as "MeasArea",
'None'::VARCHAR as "ScaleBasis",
"APreWBkWh" * wtval   as "APreWBkWh",
"APreWBkW" * wtval    as "APreWBkW",
"APreWBtherm" * wtval as "APreWBtherm",
"AStdWBkWh" * wtval   as "AStdWBkWh",
"AStdWBkW" * wtval    as "AStdWBkW",
"AStdWBtherm" * wtval as "AStdWBtherm"
from meas_impacts_2020_reshvac
JOIN wts_res_hvac on 
 wts_res_hvac.pa       = meas_impacts_2020_reshvac."PA" and 
 wts_res_hvac.bldgtype = meas_impacts_2020_reshvac."BldgType" and 
 wts_res_hvac.bldgloc  = meas_impacts_2020_reshvac."BldgLoc" and
 wts_res_hvac.bldghvac = meas_impacts_2020_reshvac."BldgHVAC"
 
;

--if a weight value is 0, find smallest weight, replace with lower number (1% of smallest weight)
